<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

function newsx_get_theme_defaults() {
	$theme_defaults = [
		// Global Colors
		'global_color_accent' => '#f84643',
		'global_color_links' => [
			'normal' => '#f84643',
			'hover'  => '#d7403e',
		],
		'global_color_headings' => '#292929',
		'global_color_body_text' => '#67737e',
		'global_color_meta' => '#8e9ba7',
		'global_color_borders' => '#e8e8e8',
		'global_color_site_background' => [
			'background-tabs' 		=> 'color',
			'background-color'      => 'rgba(255,255,255,1)',
			'gradient-color-1'      => 'rgba(20,20,20,.8)',
			'gradient-color-2'      => 'rgba(120,120,120,.8)',
			'gradient-pos-1'        => 0,
			'gradient-pos-2'        => 100,
			'gradient-angle'        => 135,
			'background-image'      => '',
			'background-repeat'     => 'repeat',
			'background-position'   => 'center center',
			'background-size'       => 'cover',
			'background-attachment' => 'scroll',
		],
		'global_color_content_background' => '#ffffff',
		'global_color_footer_enable' => true,
		'global_color_footer_text' => '#adadad',
		'global_color_footer_headings' => '#ececec',
		'global_color_footer_meta' => '#5b5b5b',
		'global_color_footer_borders' => '#484848',

		// Global Typography
		'global_font_body' => [
			'font-family'     => 'Oxygen',
			'variant'         => 'regular',
			'font-weight'     => 'normal',
			'font-style'      => 'normal',
			'font-size'       => [
				'desktop' => 14,
				'tablet'  => 14,
				'mobile'  => 14,
			],
			'line-height'     => '1.5',
			'letter-spacing'  => '0',
			'text-transform'  => 'none',
			'text-decoration' => 'none',
			'text-align'      => 'left',
		],
		'global_font_heading' => [
			'font-family'     => 'Encode Sans Condensed',
			'variant'         => 'regular',
			'font-weight'     => 'normal',
			'font-style'      => 'normal',
			'line-height'     => '1.6',
			'letter-spacing'  => '0',
			'text-transform'  => 'none',
			'text-decoration' => 'none',
			'text-align'      => 'left',
		],
		'global_font_h1' => [
			'font-family'     => '',
			'variant'         => '700',
			'font-weight'     => '700',
			'font-style'      => 'normal',
			'font-size'       => [
				'desktop' => 42,
				'tablet'  => 32,
				'mobile'  => 28,
			],
			'line-height'     => '1.2',
			'letter-spacing'  => '0.2',
			'text-transform'  => 'none',
			'text-decoration' => 'none',
			'text-align'      => 'left',
		],
		'global_font_h2' => [
			'font-family'     => '',
			'variant'         => '600',
			'font-weight'     => '600',
			'font-style'      => 'normal',
			'font-size'       => [
				'desktop' => 32,
				'tablet'  => 19,
				'mobile'  => 22,
			],
			'line-height'     => '1.2',
			'letter-spacing'  => '0.2',
			'text-transform'  => 'none',
			'text-decoration' => 'none',
			'text-align'      => 'left',
		],
		'global_font_h3' => [
			'font-family'     => '',
			'variant'         => '700',
			'font-weight'     => '700',
			'font-style'      => 'normal',
			'font-size'       => [
				'desktop' => 20,
				'tablet'  => 18,
				'mobile'  => 18,
			],
			'line-height'     => '1.4',
			'letter-spacing'  => '0.2',
			'text-transform'  => 'none',
			'text-decoration' => 'none',
			'text-align'      => 'left',
		],
		'global_font_h4' => [
			'font-family'     => '',
			'variant'         => '700',
			'font-weight'     => '700',
			'font-style'      => 'normal',
			'font-size'       => [
				'desktop' => 17,
				'tablet'  => 15,
				'mobile'  => 16,
			],
			'line-height'     => '1.3',
			'letter-spacing'  => '0.2',
			'text-transform'  => 'none',
			'text-decoration' => 'none',
			'text-align'      => 'left',
		],
		'global_font_h5' => [
			'font-family'     => '',
			'variant'         => '500',
			'font-weight'     => '500',
			'font-style'      => 'normal',
			'font-size'       => [
				'desktop' => 15,
				'tablet'  => 13,
				'mobile'  => 14,
			],
			'line-height'     => '1.3',
			'letter-spacing'  => '0',
			'text-transform'  => 'none',
			'text-decoration' => 'none',
			'text-align'      => 'left',
		],
		'global_font_h6' => [
			'font-family'     => '',
			'variant'         => '700',
			'font-weight'     => '700',
			'font-style'      => 'normal',
			'font-size'       => [
				'desktop' => 13,
				'tablet'  => 12,
				'mobile'  => 12,
			],
			'line-height'     => '1.5',
			'letter-spacing'  => '0',
			'text-transform'  => 'none',
			'text-decoration' => 'none',
			'text-align'      => 'left',
		],
		'global_latin_subset' => false,
		'global_cyrillic_subset' => false,
		'global_greek_subset' => false,
		'global_vietnamese_subset' => false,

		// Global Layout
		'global_container_width' => 1300,
		'global_container_padding' => [
			'desktop' => 20,
			'tablet'  => 20,
			'mobile'  => 20,
		],
		'global_header_width' => 'boxed',
		'global_content_width' => 'boxed',
		'global_single_content_width' => 'boxed',
		'global_footer_width' => 'boxed',
		'global_island_style' => false,
		'global_border_radius' => true,
		'global_image_hover_effects' => true,

		// Global Sidebar
		'global_sidebar_width' => 30,
		'global_sidebar_content_distance' => [
			'desktop' => 60,
			'tablet'  => 30,
			'mobile'  => 30,
		],
		'global_sidebar_sticky' => false,
		'global_blog_sidebar_display' => 'right',
		'global_blog_single_sidebar_display' => 'right',
		'global_single_page_sidebar_display' => 'right',
		'global_term_archive_sidebar_display' => 'right',

		// Global Widgets
		'global_widget_accent_color' => '',
		'global_widget_font_size' => [
			'desktop' => 16,
			'tablet'  => '',
			'mobile'  => '',
		],
		'global_widget_title_style' => 's0',

		// Global Categories
		'global_category_style' => 's0',
		'global_category_enable_cc' => true,


		// Header Top
        'section_hd_top_enable' => true,
		'section_hd_top_elements' => [
			[
				'hd_top_select_element' => 'news-ticker',
				'hd_top_element_position' => 'left',
				'hd_top_element_duplicate' => false,
			],
		],
        'section_hd_top_height' => [
			'desktop' => 30,
			'tablet'  => '',
			'mobile'  => ''
		],
		'section_hd_top_bg' => [
			'background-tabs' 		=> 'color',
			'background-color'      => '#f84643',
			'gradient-color-1'      => 'rgba(20,20,20,.8)',
			'gradient-color-2'      => 'rgba(120,120,120,.8)',
			'gradient-pos-1'        => 0,
			'gradient-pos-2'        => 100,
			'gradient-angle'        => 135,
			'background-image'      => '',
			'background-repeat'     => 'repeat',
			'background-position'   => 'center center',
			'background-size'       => 'cover',
			'background-attachment' => 'scroll',
		],
		'section_hd_top_bd_color' => '#e8e8e8',
		'section_hd_top_bd_width' => '0',

		// Header Middle
        'section_hd_middle_enable' => true,
		'section_hd_middle_elements' => [
			[
				'hd_middle_select_element' => 'site-identity',
				'hd_middle_element_position' => 'left',
				'hd_middle_element_duplicate' => false,
			],
			[
				'hd_middle_select_element' => 'primary-menu',
				'hd_middle_element_position' => 'left',
				'hd_middle_element_duplicate' => false,
			],
			[
				'hd_middle_select_element' => 'social-icons',
				'hd_middle_element_position' => 'right',
				'hd_middle_element_duplicate' => false,
			],
			[
				'hd_middle_select_element' => 'search',
				'hd_middle_element_position' => 'right',
				'hd_middle_element_duplicate' => false,
			],
		],
        'section_hd_middle_height' => [
			'desktop' => 120,
			'tablet'  => '',
			'mobile'  => ''
		],
		'site_title_visibility' => [ 'desktop', 'tablet', 'mobile' ],
		'site_tagline_visibility' => [ 'desktop', 'tablet', 'mobile' ],
		'section_hd_middle_bg' => [
			'background-tabs' 		=> 'color',
			'background-color'      => 'rgba(255,255,255,1)',
			'gradient-color-1'      => 'rgba(20,20,20,.8)',
			'gradient-color-2'      => 'rgba(120,120,120,.8)',
			'gradient-pos-1'        => 0,
			'gradient-pos-2'        => 100,
			'gradient-angle'        => 135,
			'background-image'      => '',
			'background-repeat'     => 'repeat',
			'background-position'   => 'center center',
			'background-size'       => 'cover',
			'background-attachment' => 'scroll',
		],
		'section_hd_middle_bd_color' => '#e8e8e8',
		'section_hd_middle_bd_width' => '1',
		'hd_middle_padding' => [
			'desktop' => [
				'top'      => '10',
				'right'    => '',
				'bottom'   => '10',
				'left'     => '',
				'isLinked' => false,
			],
			'tablet'  => [
				'top'      => '',
				'right'    => '',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => false,
			],
			'mobile'  => [
				'top'      => '',
				'right'    => '',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => false,
			],
		],

		// Header Bottom
        'section_hd_bottom_enable' => true,
		'section_hd_bottom_elements' => [
			[
				'hd_bottom_select_element' => 'offcanvas',
				'hd_bottom_element_position' => 'left',
				'hd_bottom_element_duplicate' => false,
			],
			[
				'hd_bottom_select_element' => 'secondary-menu',
				'hd_bottom_element_position' => 'left',
				'hd_bottom_element_duplicate' => false,	
			],
			[
				'hd_bottom_select_element' => 'date-and-time',
				'hd_bottom_element_position' => 'right',
				'hd_bottom_element_duplicate' => false,
			],
			[
				'hd_bottom_select_element' => 'random-post',
				'hd_bottom_element_position' => 'right',
				'hd_bottom_element_duplicate' => false,
			],
			[
				'hd_bottom_select_element' => 'dark-switcher',
				'hd_bottom_element_position' => 'right',
				'hd_bottom_element_duplicate' => false,
			],
		],
        'section_hd_bottom_height' => [
			'desktop' => 40,
			'tablet'  => '',
			'mobile'  => ''
		],
		'section_hd_bottom_bg' => [
			'background-tabs' 		=> 'color',
			'background-color'      => 'rgba(255,255,255,1)',
			'gradient-color-1'      => 'rgba(20,20,20,.8)',
			'gradient-color-2'      => 'rgba(120,120,120,.8)',
			'gradient-pos-1'        => 0,
			'gradient-pos-2'        => 100,
			'gradient-angle'        => 135,
			'background-image'      => '',
			'background-repeat'     => 'repeat',
			'background-position'   => 'center center',
			'background-size'       => 'cover',
			'background-attachment' => 'scroll',
		],
		'section_hd_bottom_bd_color' => '#e8e8e8',
		'section_hd_bottom_bd_width' => '1',

		// Logo / Site Title
		'retina_logo_sw' => false,
		'retina_logo' => '',
		'dark_logo' => '',
		'inline_logo_title' => 'row',
		'logo_width' => [
			'desktop' => 50,
			'tablet'  => '',
			'mobile'  => '',
		],
		'logo_title_visibility' => [ 'desktop', 'tablet', 'mobile' ],
		'logo_title_color' => [
			'normal' => '',
			'hover'  => '',
		],
		'logo_tagline_color' => '#67737e',
		'logo_title_font' => [
			'font-family'     => 'Encode Sans Condensed',
			'variant'         => '700',
			'font-weight'     => '700',
			'font-style'      => 'normal',
			'line-height'     => '1.3',
			'letter-spacing'  => '0',
			'text-transform'  => 'none',
			'text-decoration' => 'none',
			'text-align'      => 'left',
		],
		'logo_title_font_size' => [
			'desktop' => 40,
			'tablet'  => 40,
			'mobile'  => 23,
		],
		'logo_tagline_font_size' => [
			'desktop' => 12,
			'tablet'  => 12,
			'mobile'  => 12,
		],
		'logo_margin' => [
			'desktop' => [
				'top'      => '',
				'right'    => '10',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => false,
			],
			'tablet'  => [
				'top'      => '',
				'right'    => '0',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => false,
			],
			'mobile'  => [
				'top'      => '',
				'right'    => '0',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => false,
			],
		],

		// Primary Menu
		'header_pm_hover_effect' => 'fade',
		'header_pm_submenu_animation' => 'fade',
		'header_pm_show_home_icon' => true,
		'header_pm_toggle_icon' => 'chevron-down',
		'header_pm_toggle_style' => 'minimal',
		'header_pm_toggle_label' => 'Menu',
		'header_pm_color' => [
			'normal' => '',
			'hover' => '',
		],
		'header_pm_bg_color' => [
			'normal' => '',
			'hover' => '',
		],
		'header_pm_font' => [
			'font-family'     => 'Encode Sans Condensed',
			'variant'         => '700',
			'font-weight'     => '700',
			'font-style'      => 'normal',
			'line-height'     => '1.5',
			'letter-spacing'  => '0',
			'text-transform'  => 'none',
			'text-decoration' => 'none',
			'text-align'      => 'left',
		],
		'header_pm_item_font_size' => [
			'desktop' => '19',
			'tablet'  => '15',
			'mobile'  => '',
		],
		'header_pm_subitem_font_size' => [
			'desktop' => '13',
			'tablet'  => '',
			'mobile'  => '',
		],
		'header_pm_home_icon_size' => [
			'desktop' => '',
			'tablet'  => '',
			'mobile'  => '',
		],
		'header_pm_submenu_width' => '200',
		'header_pm_submenu_offset' => '15',
		'header_pm_submenu_bd_color' => '',
		'header_pm_submenu_bd_width' => '2',
		'header_pm_submenu_bd_radius' => '',
		'header_pm_submenu_divider' => true,
		'header_pm_submenu_div_size' => '1',
		'header_pm_submenu_div_color' => '#f6f6f6',
		'header_pm_toggle_color' => '',
		'header_pm_toggle_bg_color' => '',
		'header_pm_toggle_icon_size' => '14',
		'header_pm_toggle_label_size' => '15',
		'header_pm_toggle_bd_radius' => '',
		'header_pm_mobile_drop_divider' => true,
		'header_pm_mobile_drop_div_color' => '#f6f6f6',
		'header_pm_item_padding' => [
			'desktop' => [
				'top'      => '',
				'right'    => '',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => true,
			],
			'tablet'  => [
				'top'      => '5',
				'right'    => '5',
				'bottom'   => '5',
				'left'     => '5',
				'isLinked' => false,
			],
			'mobile'  => [
				'top'      => '',
				'right'    => '',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => false,
			],
		],
		'header_pm_item_margin' => [
			'desktop' => [
				'top'      => '',
				'right'    => '12',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => false,
			],
			'tablet'  => [
				'top'      => '',
				'right'    => '',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => false,
			],
			'mobile'  => [
				'top'      => '',
				'right'    => '',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => false,
			],
		],
		'header_pm_margin' => [
			'desktop' => [
				'top'      => '',
				'right'    => '',
				'bottom'   => '',
				'left'     => '20',
				'isLinked' => false,
			],
			'tablet'  => [
				'top'      => '',
				'right'    => '',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => true,
			],
			'mobile'  => [
				'top'      => '',
				'right'    => '',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => true,
			],
		],

		// Secondary Menu
		'header_sm_hover_effect' => 'fade',
		'header_sm_submenu_animation' => 'fade',
		'header_sm_color' => [
			'normal' => '#67737e',
			'hover' => '',
		],
		'header_sm_bg_color' => [
			'normal' => '',
			'hover' => '',
		],
		'header_sm_font' => [
			'font-family'     => 'Oxygen',
			'variant'         => 'regular',
			'font-weight'     => 'normal',
			'font-style'      => 'normal',
			'line-height'     => '1.5',
			'letter-spacing'  => '0',
			'text-transform'  => 'none',
			'text-decoration' => 'none',
			'text-align'      => 'left',
		],
		'header_sm_item_font_size' => [
			'desktop' => '13',
			'tablet'  => '',
			'mobile'  => '',
		],
		'header_sm_subitem_font_size' => [
			'desktop' => '12',
			'tablet'  => '',
			'mobile'  => '',
		],
		'header_sm_submenu_width' => '200',
		'header_sm_submenu_offset' => '11',
		'header_sm_submenu_bd_color' => '',
		'header_sm_submenu_bd_width' => '0',
		'header_sm_submenu_bd_radius' => '',
		'header_sm_submenu_divider' => true,
		'header_sm_submenu_div_size' => '1',
		'header_sm_submenu_div_color' => '#f6f6f6',
		'header_sm_item_padding' => [
			'desktop' => [
				'top'      => '',
				'right'    => '',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => true,
			],
			'tablet'  => [
				'top'      => '',
				'right'    => '',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => true,
			],
			'mobile'  => [
				'top'      => '',
				'right'    => '',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => true,
			],
		],
		'header_sm_item_margin' => [
			'desktop' => [
				'top'      => '',
				'right'    => '15',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => false,
			],
			'tablet'  => [
				'top'      => '',
				'right'    => '',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => false,
			],
			'mobile'  => [
				'top'      => '',
				'right'    => '',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => false,
			],
		],
		'header_sm_margin' => [
			'desktop' => [
				'top'      => '',
				'right'    => '',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => true,
			],
			'tablet'  => [
				'top'      => '',
				'right'    => '',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => true,
			],
			'mobile'  => [
				'top'      => '',
				'right'    => '',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => true,
			],
		],
		
		// Date and Time
		'date_format' => 'default',
		'date_show_time' => false,
		'date_visibility' => [ 'desktop', 'tablet', '' ],
		'header_date_color' => '',
		'header_date_font_size' => [
			'desktop' => '13',
			'tablet'  => '13',
			'mobile'  => '13',
		],
		'header_date_margin' => [
			'desktop' => [
				'top'      => '',
				'right'    => '',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => true,
			],
			'tablet'  => [
				'top'      => '',
				'right'    => '',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => true,
			],
			'mobile'  => [
				'top'      => '',
				'right'    => '',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => true,
			],
		],

		// News Ticker
		'header_nt_query' => 'dynamic',
		'header_nt_orderby' => 'date',
		'header_nt_published_days' => 365,
		'header_nt_categories' => '',
		'header_nt_tags' => '',
		'header_nt_offset' => 0,
		'header_nt_heading_text' => 'Hot News',
		'header_nt_heading_bg_style' => 's0',
		'header_nt_heading_icon_type' => 'fire',
		'header_nt_columns' => '1-column',
		'header_nt_posts_per_page' => 6,
		'header_nt_letter_count' => '',
		'header_nt_type_select' => 'marquee',
		'header_nt_show_images' => '',
		'header_nt_autoplay' => '',
		'header_nt_autoplay_delay' => 3000,
		'header_nt_nav' => true,
		'header_nt_nav_style' => 'default',
		'header_nt_heading_text_color' => '#ffffff',
		'header_nt_heading_icon_color' => '#ffffff',
		'header_nt_heading_bg_color' => '',
		'header_nt_heading_font_size' => [
			'desktop' => '14',
			'tablet'  => '14',
			'mobile'  => '14',
		],
		'header_nt_content_text_color' => [
			'normal' => '#ffffff',
			'hover' => '#ffffff',
		],
		'header_nt_content_bg_color' => '',
		'header_nt_nav_color' => [
			'normal' => '#ffffff',
			'hover' => '#ffffff',
		],
		'header_nt_nav_bg_color' => [
			'normal' => '#ffffff',
			'hover' => '#ffffff',
		],
		'header_nt_content_font_size' => [
			'desktop' => '12',
			'tablet'  => '12',
			'mobile'  => '12',
		],
		'header_nt_nav_icon_size' => [
			'desktop' => 14,
			'tablet'  => 14,
			'mobile'  => 14,
		],
		'header_nt_heading_padding' => [
			'desktop' => [
				'top'      => '',
				'right'    => '',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => true,
			],
		],
		'header_nt_nav_padding' => [
			'desktop' => [
				'top'      => '',
				'right'    => '',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => true,
			],
		],
		'header_nt_margin' => [
			'desktop' => [
				'top'      => '',
				'right'    => '',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => true,
			],
		],

		// Social Icons
		'header_social_icons' => [
			[
				'header_social_icons_select' => 'facebook-f',
				'header_social_icons_url' => '#',
				'header_social_icons_label' => '',
			],
			[
				'header_social_icons_select' => 'x-twitter',
				'header_social_icons_url' => '#',
				'header_social_icons_label' => '',
			],
			[
				'header_social_icons_select' => 'instagram-square',
				'header_social_icons_url' => '#',
				'header_social_icons_label' => '',
			],
			[
				'header_social_icons_select' => 'pinterest-p',
				'header_social_icons_url' => '#',
				'header_social_icons_label' => '',
			],
			[
				'header_social_icons_select' => 'youtube',
				'header_social_icons_url' => '#',
				'header_social_icons_label' => '',
			],
		],
		'header_si_tooltips' => true,
		'header_si_visibility' => [ 'desktop', 'tablet', '' ],
		'header_si_color' => [
			'normal' => '',
			'hover' => '',
		],
		'header_si_icon_size' => [
			'desktop' => 16,
			'tablet'  => '',
			'mobile'  => '',
		],
		'header_si_label_size' => [
			'desktop' => 12,
			'tablet'  => '',
			'mobile'  => '',
		],
		'header_si_margin' => [
			'desktop' => [
				'top'      => '',
				'right'    => '',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => true,
			],
			'tablet'  => [
				'top'      => '',
				'right'    => '',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => true,
			],
			'mobile'  => [
				'top'      => '',
				'right'    => '',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => true,
			],
		],

		// Search
		'header_search_query' => 'all',
		'header_search_placeholder' => 'Type and hit enter...',
		'header_search_ajax_enable' => '',
		'header_search_style' => 's1',
		'header_search_visibility' => [ 'desktop', 'tablet', 'mobile' ],
		'header_search_duplicate_visibility' => [ 'desktop', 'tablet', 'mobile' ],
		'header_search_icon_color' => [
			'normal' => '',
			'hover' => '',
		],
		'header_search_icon_size' => [
			'desktop' => '',
			'tablet'  => '',
			'mobile'  => '',
		],
		'header_search_width' => [
			'desktop' => '200',
			'tablet'  => '',
			'mobile'  => '',
		],
		'header_search_bg_color' => '',
		'header_search_margin' => [
			'desktop' => [
				'top'      => '',
				'right'    => '',
				'bottom'   => '',
				'left'     => '10',
				'isLinked' => false,
			],
			'tablet'  => [
				'top'      => '',
				'right'    => '',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => false,
			],
			'mobile'  => [
				'top'      => '',
				'right'    => '',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => false,
			],
		],

		// Off-Canvas
		'header_ofc_icon' => 'hamburger-thin',
		'header_ofc_width' => 300,
		'header_ofc_visibility' => ['desktop', 'tablet', 'mobile'],
		'header_ofc_icon_color' => [
			'normal' => '#111111',
			'hover' => '#111111',
		],
		'header_ofc_icon_size' => [
			'desktop' => 20,
			'tablet'  => '',
			'mobile'  => '',
		],
		'header_ofc_padding' => [
			'desktop' => [
				'top'      => '40',
				'right'    => '20',
				'bottom'   => '40',
				'left'     => '20',
				'isLinked' => false,
			],
			'tablet' => [
				'top'      => '',
				'right'    => '',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => true,
			],
			'mobile' => [
				'top'      => '',
				'right'    => '',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => true,
			],
		],
		'header_ofc_icon_margin' => [
			'desktop' => [
				'top'      => '',
				'right'    => '5',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => false,
			],
			'tablet' => [
				'top'      => '',
				'right'    => '',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => false,
			],
			'mobile' => [
				'top'      => '',
				'right'    => '',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => false,
			],
		],

		// CTA Button
		'header_cta_text' => 'Call to Action',
		'header_cta_icon' => 'star',
		'header_cta_icon_pos' => 'right',
		'header_cta_link' => 'https://wp-royal-themes.com/',
		'header_cta_new_tab' => false,
		'header_cta_visibility' => [ 'desktop', 'tablet', 'mobile' ],
		'header_cta_text_color' => [
			'normal' => '#67737e',
			'hover' => '#ffffff',
		],
		'header_cta_bg_color' => [
			'normal' => '',
			'hover' => '#67737e',
		],
		'header_cta_border_color' => [
			'normal' => '#67737e',
			'hover' => '#67737e',
		],
		'header_cta_font' => [
			'font-family'     => 'Oxygen',
			'variant'         => 'regular',
			'font-weight'     => 'normal',
			'font-style'      => 'normal',
			'line-height'     => '1.5',
			'letter-spacing'  => '0',
			'text-transform'  => 'none',
			'text-decoration' => 'none',
			'text-align'      => 'left',
		],
		'header_cta_font_size' => [
			'desktop' => '13',
			'tablet'  => '13',
			'mobile'  => '13',
		],
		'header_cta_icon_size' => [
			'desktop' => '14',
			'tablet'  => '14',
			'mobile'  => '14',
		],
		'header_cta_border_width' => 1,
		'header_cta_border_radius' => 3,
		'header_cta_padding' => [
			'desktop' => [
				'top'      => '',
				'right'    => '',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => true,
			],
			'tablet'  => [
				'top'      => '',
				'right'    => '',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => true,
			],
			'mobile'  => [
				'top'      => '',
				'right'    => '',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => true,
			],
		],
		'header_cta_margin' => [
			'desktop' => [
				'top'      => '',
				'right'    => '',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => true,
			],
			'tablet'  => [
				'top'      => '',
				'right'    => '',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => true,
			],
			'mobile'  => [
				'top'      => '',
				'right'    => '',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => true,
			],
		],

		// Weather
		'header_weather_api_key' => '',
		'header_weather_unit' => 'cel',
		'header_weather_location_type' => 'custom',
		'header_weather_location' => 'New York',
		'header_weather_visibility' => [ 'desktop', 'tablet', 'mobile' ],
		'header_weather_color' => '',
		'header_weather_icon_size' => [
			'desktop' => '',
			'tablet'  => '',
			'mobile'  => '',
		],
		'header_weather_font_size' => [
			'desktop' => '',
			'tablet'  => '',
			'mobile'  => '',
		],
		'header_weather_margin' => [
			'desktop' => [
				'top'      => '',
				'right'    => '',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => true,
			],
			'tablet'  => [
				'top'      => '',
				'right'    => '',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => true,
			],
			'mobile'  => [
				'top'      => '',
				'right'    => '',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => true,
			],
		],

		// Random Post
		'random_post_icon' => 'random',
		'random_post_show_tooltip' => false,
		'random_post_tooltip' => 'Random Post',
		'random_post_visibility' => [ 'desktop', 'tablet', 'mobile' ],
		'random_post_color' => [
			'normal' => '',
			'hover' => '',
		],
		'random_post_icon_size' => [
			'desktop' => '16',
			'tablet'  => '',
			'mobile'  => '',
		],
		'random_post_margin' => [
			'desktop' => [
				'top'      => '',
				'right'    => '',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => true,
			],
			'tablet'  => [
				'top'      => '',
				'right'    => '',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => true,
			],
			'mobile'  => [
				'top'      => '',
				'right'    => '',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => true,
			],
		],

		// Dark Mode Switcher
		'dark_switcher_default' => 'light',
		'dark_switcher_show_tooltip' => true,
		'dark_switcher_tooltip_light' => 'Switch to Dark',
		'dark_switcher_tooltip_dark' => 'Switch to Light',
		'dark_switcher_visibility' => [ 'desktop', 'tablet', 'mobile' ],
		'dark_switcher_color' => [
			'normal' => '',
			'hover' => '',
		],
		'dark_switcher_icon_size' => [
			'desktop' => '',
			'tablet'  => '',
			'mobile'  => '',
		],
		'dark_switcher_margin' => [
			'desktop' => [
				'top'      => '',
				'right'    => '',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => true,
			],
			'tablet'  => [
				'top'      => '',
				'right'    => '',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => true,
			],
			'mobile'  => [
				'top'      => '',
				'right'    => '',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => true,
			],
		],

		// Header Custom HTML 1
		'header_html1_editor' => '',
		'header_html1_visibility' => [ 'desktop', 'tablet', 'mobile' ],
		'header_html1_text_color' => '',
		'header_html1_link_color' => [
			'normal' => '',
			'hover' => '',
		],
		'header_html1_font_size' => [
			'desktop' => '',
			'tablet'  => '',
			'mobile'  => '',
		],
		'header_html1_margin' => [
			'desktop' => [
				'top'      => '',
				'right'    => '',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => true,
			],
			'tablet'  => [
				'top'      => '',
				'right'    => '',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => true,
			],
			'mobile'  => [
				'top'      => '',
				'right'    => '',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => true,
			],
		],

		// Header Custom HTML 2
		'header_html2_editor' => '',
		'header_html2_visibility' => [ 'desktop', 'tablet', 'mobile' ],
		'header_html2_text_color' => '',
		'header_html2_link_color' => [
			'normal' => '',
			'hover' => '',
		],
		'header_html2_font_size' => [
			'desktop' => '',
			'tablet'  => '',
			'mobile'  => '',
		],
		'header_html2_margin' => [
			'desktop' => [
				'top'      => '',
				'right'    => '',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => true,
			],
			'tablet'  => [
				'top'      => '',
				'right'    => '',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => true,
			],
			'mobile'  => [
				'top'      => '',
				'right'    => '',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => true,
			],
		],

		// Header Widgets 1
		'header_widgets_1_visibility' => [ 'desktop', 'tablet', 'mobile' ],

		// Header Widgets 2
		'header_widgets_2_visibility' => [ 'desktop', 'tablet', 'mobile' ],

		// Front page
		'front_page_sections' => [
			[
				'widget_area' => '1',
				'layout' => 'content-nosidebar',
				'stretch' => false,
			]
		],
		'front_page_hide_blog_feed' => false,

		// Footer Top
        'section_ft_top_enable' => false,
		'section_ft_top_elements' => [
			[
				'ft_top_select_element' => 'social-icons',
				'ft_top_element_position' => '1',
				'edit_element_options' => 'options'
			],
		],
		'section_ft_top_height' => [
			'desktop' => 100,
			'tablet'  => '',
			'mobile'  => ''
		],
		'section_ft_top_columns' => '1',
		'section_ft_top_vertical_align' => 'center',
		'section_ft_top_columns_gap' => [
			'desktop' => 50,
			'tablet'  => '',
			'mobile'  => ''
		],
		'section_ft_top_bg' => [
			'background-tabs' 		=> 'color',
			'background-color'      => '#191919',
			'gradient-color-1'      => 'rgba(20,20,20,.8)',
			'gradient-color-2'      => 'rgba(120,120,120,.8)',
			'gradient-pos-1'        => 0,
			'gradient-pos-2'        => 100,
			'gradient-angle'        => 135,
			'background-image'      => '',
			'background-repeat'     => 'repeat',
			'background-position'   => 'center center',
			'background-size'       => 'cover',
			'background-attachment' => 'scroll',
		],
		'section_ft_top_bd_color' => '',
		'section_ft_top_bd_width' => '1',
		'section_ft_top_padding' => [
			'desktop' => [
				'top'      => '20',
				'right'    => '20',
				'bottom'   => '20',
				'left'     => '20',
				'isLinked' => true,
			],
			'tablet'  => [
				'top'      => '',
				'right'    => '',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => true,
			],
			'mobile'  => [
				'top'      => '',
				'right'    => '',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => true,
			],
		],

		// Footer Middle
        'section_ft_middle_enable' => false,
		'section_ft_middle_elements' => [
			[
				'ft_middle_select_element' => 'footer-widgets-1',
				'ft_middle_element_position' => '1',
				'edit_element_options' => 'options'
			],
			[
				'ft_middle_select_element' => 'footer-widgets-2',
				'ft_middle_element_position' => '2',
				'edit_element_options' => 'options'
			],
			[
				'ft_middle_select_element' => 'footer-widgets-3',
				'ft_middle_element_position' => '3',
				'edit_element_options' => 'options'
			],
			[
				'ft_middle_select_element' => 'footer-widgets-4',
				'ft_middle_element_position' => '4',
				'edit_element_options' => 'options'
			],
		],
		'section_ft_middle_height' => [
			'desktop' => 100,
			'tablet'  => '',
			'mobile'  => ''
		],
		'section_ft_middle_columns' => '4',
		'section_ft_middle_vertical_align' => 'flex-start',
		'section_ft_middle_columns_gap' => [
			'desktop' => 50,
			'tablet'  => '',
			'mobile'  => ''
		],
		'section_ft_middle_bg' => [
			'background-tabs' 		=> 'color',
			'background-color'      => '#191919',
			'gradient-color-1'      => 'rgba(20,20,20,.8)',
			'gradient-color-2'      => 'rgba(120,120,120,.8)',
			'gradient-pos-1'        => 0,
			'gradient-pos-2'        => 100,
			'gradient-angle'        => 135,
			'background-image'      => '',
			'background-repeat'     => 'repeat',
			'background-position'   => 'center center',
			'background-size'       => 'cover',
			'background-attachment' => 'scroll',
		],
		'section_ft_middle_bd_color' => '#222222',
		'section_ft_middle_bd_width' => '1',
		'section_ft_middle_padding' => [
			'desktop' => [
				'top'      => '20',
				'right'    => '20',
				'bottom'   => '20',
				'left'     => '20',
				'isLinked' => true,
			],
			'tablet'  => [
				'top'      => '',
				'right'    => '',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => true,
			],
			'mobile'  => [
				'top'      => '',
				'right'    => '',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => true,
			],
		],

		// Footer Bottom
		'section_ft_bottom_enable' => true,
		'section_ft_bottom_elements' => [
			[
				'ft_bottom_select_element' => 'copyright',
				'ft_bottom_element_position' => '1',
			],
		],
        'section_ft_bottom_height' => [
			'desktop' => 30,
			'tablet'  => '',
			'mobile'  => ''
		],
		'section_ft_bottom_columns' => '1',
		'section_ft_bottom_vertical_align' => 'center',
		'section_ft_bottom_columns_gap' => [
			'desktop' => 50,
			'tablet'  => '',
			'mobile'  => ''
		],
		'section_ft_bottom_bg' => [
			'background-tabs' 		=> 'color',
			'background-color'      => '#111111',
			'gradient-color-1'      => 'rgba(20,20,20,.8)',
			'gradient-color-2'      => 'rgba(120,120,120,.8)',
			'gradient-pos-1'        => 0,
			'gradient-pos-2'        => 100,
			'gradient-angle'        => 135,
			'background-image'      => '',
			'background-repeat'     => 'repeat',
			'background-position'   => 'center center',
			'background-size'       => 'cover',
			'background-attachment' => 'scroll',
		],
		'section_ft_bottom_bd_color' => '#222222',
		'section_ft_bottom_bd_width' => '1',
		'section_ft_bottom_padding' => [
			'desktop' => [
				'top'      => '20',
				'right'    => '20',
				'bottom'   => '20',
				'left'     => '20',
				'isLinked' => true,
			],
			'tablet'  => [
				'top'      => '',
				'right'    => '',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => true,
			],
			'mobile'  => [
				'top'      => '',
				'right'    => '',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => true,
			],
		],

		// Footer Logo
		'footer_logo' => '',
		'ft_retina_logo_sw' => false,
		'ft_retina_logo' => '',
		'ft_dark_logo' => '',

		// Copyright
		'copyright_editor' => 'Copyright [copyright] [current_year] [site_title]',
		'copyright_align' => [
			'desktop' => 'center',
			'tablet'  => 'center',
			'mobile'  => 'center',
		],
		'copyright_visibility' => [ 'desktop', 'tablet', 'mobile' ],
		'copyright_text_color' => '#888888',
		'copyright_link_color' => [
			'normal' => '#bcbcbc',
			'hover' => '',
		],
		'copyright_font_size' => [
			'desktop' => '12',
			'tablet'  => '',
			'mobile'  => '',
		],
		'copyright_margin' => [
			'desktop' => [
				'top'      => '',
				'right'    => '',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => true,
			],
			'tablet'  => [
				'top'      => '',
				'right'    => '',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => true,
			],
			'mobile'  => [
				'top'      => '',
				'right'    => '',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => true,
			],
		],

		// Footer Menu
		'footer_menu_layout' => 'row',
		'footer_menu_align' => [
			'desktop' => 'flex-start',
			'tablet'  => 'flex-start',
			'mobile'  => 'flex-start',
		],
		'footer_menu_visibility' => [ 'desktop', 'tablet', 'mobile' ],
		'footer_menu_color' => [ 
			'normal' => '',
			'hover' => ''
		],
		'footer_menu_bg_color' => [ 
			'normal' => '',
			'hover' => ''
		],
		'footer_menu_item_font_size' => [
			'desktop' => '',
			'tablet'  => '',
			'mobile'  => '',
		],
		'footer_menu_item_padding' => [
			'desktop' => [
				'top'      => '',
				'right'    => '',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => true,
			],
			'tablet'  => [
				'top'      => '',
				'right'    => '',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => true,
			],
			'mobile'  => [
				'top'      => '',
				'right'    => '',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => true,
			],
		],
		'footer_menu_margin' => [
			'desktop' => [
				'top'      => '',
				'right'    => '',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => true,
			],
			'tablet'  => [
				'top'      => '',
				'right'    => '',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => true,
			],
			'mobile'  => [
				'top'      => '',
				'right'    => '',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => true,
			],
		],

		// Social Icons
		'footer_social_icons' => [
			[
				'footer_social_icons_select' => 'facebook',
				'footer_social_icons_url' => '#',
				'footer_social_icons_label' => '',
			],
			[
				'footer_social_icons_select' => 'x-twitter',
				'footer_social_icons_url' => '#',
				'footer_social_icons_label' => '',
			],
			[
				'footer_social_icons_select' => 'instagram',
				'footer_social_icons_url' => '#',
				'footer_social_icons_label' => '',
			],
			[
				'footer_social_icons_select' => 'pinterest',
				'footer_social_icons_url' => '#',
				'footer_social_icons_label' => '',
			],
		],
		'footer_si_tooltips' => false,
		'footer_si_align' => [
			'desktop' => 'flex-start',
			'tablet'  => 'flex-start',
			'mobile'  => 'flex-start',
		],
		'footer_si_visibility' => [ 'desktop', 'tablet', 'mobile' ],
		'footer_si_color' => [
			'normal' => '',
			'hover' => '',
		],
		'footer_si_icon_size' => [
			'desktop' => '',
			'tablet'  => '',
			'mobile'  => '',
		],
		'footer_si_label_size' => [
			'desktop' => '',
			'tablet'  => '',
			'mobile'  => '',
		],
		'footer_si_margin' => [
			'desktop' => [
				'top'      => '',
				'right'    => '',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => true,
			],
			'tablet'  => [
				'top'      => '',
				'right'    => '',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => true,
			],
			'mobile'  => [
				'top'      => '',
				'right'    => '',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => true,
			],
		],

		// Footer Custom HTML 1
		'footer_html1_editor' => '',
		'footer_html1_visibility' => [ 'desktop', 'tablet', 'mobile' ],
		'footer_html1_text_color' => '',
		'footer_html1_link_color' => [
			'normal' => '',
			'hover' => '',
		],
		'footer_html1_font_size' => [
			'desktop' => '',
			'tablet'  => '',
			'mobile'  => '',
		],
		'footer_html1_margin' => [
			'desktop' => [
				'top'      => '',
				'right'    => '',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => true,
			],
			'tablet'  => [
				'top'      => '',
				'right'    => '',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => true,
			],
			'mobile'  => [
				'top'      => '',
				'right'    => '',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => true,
			],
		],

		// Footer Custom HTML 2
		'footer_html2_editor' => '',
		'footer_html2_visibility' => [ 'desktop', 'tablet', 'mobile' ],
		'footer_html2_text_color' => '',
		'footer_html2_link_color' => [
			'normal' => '',
			'hover' => '',
		],
		'footer_html2_font_size' => [
			'desktop' => '',
			'tablet'  => '',
			'mobile'  => '',
		],
		'footer_html2_margin' => [
			'desktop' => [
				'top'      => '',
				'right'    => '',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => true,
			],
			'tablet'  => [
				'top'      => '',
				'right'    => '',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => true,
			],
			'mobile'  => [
				'top'      => '',
				'right'    => '',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => true,
			],
		],

		// Footer Back to Top
		'ft_backtop_enable' => true,
		'ft_backtop_icon' => 'arrow-up',
		'ft_backtop_visibility' => [ 'desktop', 'tablet', 'mobile' ],
		'ft_backtop_transparent' => false,
		'ft_backtop_color' => [
			'normal' => '',
			'hover' => '',
		],
		'ft_backtop_bg_color' => [
			'normal' => '',
			'hover' => '',
		],

		// Blog Page: Posts Slider
		'section_bp_slider_enable' => true,
		'bp_slider_query' => 'dynamic',
		'bp_slider_orderby' => 'date',
		'bp_slider_published_days' => 365,
		'bp_slider_categories' => '',
		'bp_slider_tags' => '',
		'bp_slider_posts_per_page' => 3,
		'bp_slider_offset' => 0,
		'bp_slider_columns' => '1-column',
		'bp_slider_elements_preset' => 's0',
		'bp_slider_image_size' => 'newsx-1200x600',
		'bp_slider_gutter' => [
			'desktop' => '',
			'tablet'  => '',
			'mobile'  => '',
		],
		'bp_slider_center_content' => true,
		'bp_slider_autoplay' => '',
		'bp_slider_autoplay_delay' => 3000,
		'bp_slider_title_tag' => 'h1',
		'bp_slider_title_letter_count' => '',
		'bp_slider_excerpt_letter_count' => 50,
		'bp_slider_date_format' => 'default',
		'bp_slider_date_show_time' => false,
		'bp_slider_show_avatar' => false,
		'bp_slider_read_more_text' => 'Read More',
		'bp_slider_nav_arrows' => true,
		'bp_slider_nav_style' => 's0',

		// Blog Page: Posts Feed
		'bp_feed_layout' => 'list-7',
		'bp_feed_elements_preset' => 's0',
		'bp_feed_gutter' => [
			'desktop' => '',
			'tablet'  => '',
			'mobile'  => '',
		],
		'bp_feed_title_tag' => 'h3',
		'bp_feed_title_letter_count' => '',
		'bp_feed_excerpt_letter_count' => 200,
		'bp_feed_date_format' => 'default',
		'bp_feed_date_show_time' => false,
		'bp_feed_show_avatar' => false,
		'bp_feed_avatar_size' => 32,
		'bp_feed_read_more_text' => 'Read More',
		'bp_feed_image_link' => true,

		// Blog Single
		'bs_header_layout_preset' => 's5',
		'bs_header_show_breadcrumbs' => true,
		'bs_header_show_categories' => true,
		'bs_header_show_author' => false,
		'bs_header_show_avatar' => false,
		'bs_header_avatar_size' => 32,
		'bs_header_show_comments' => false,
		'bs_header_show_reading_time' => false,
		'bs_header_show_post_views' => false,
		'bs_header_date_display' => 'published',
		'bs_header_date_position' => 'inline',
		'bs_header_show_time' => false,
		'bs_header_show_meta_icons' => true,
		'bs_content_underline_links' => true,
		'bs_content_text_color' => '',
		'bs_content_font_size' => [
			'desktop' => '14',
			'tablet'  => '',
			'mobile'  => '',
		],
		'bs_sharing_show_header' => false,
		'bs_sharing_show_content' => true,
		'bs_sharing_text' => 'Share this Article',
		'bs_sharing_style' => 's0',
		'bs_sharing_show_labels' => false,
		'bs_sharing_show_float' => false,
		'bs_sharing_fl_text' => 'Share',
		'bs_sharing_fl_style' => 's0',
		'bs_sharing_fl_pos' => 'outside',
		'bs_sharing_original_colors' => false,
		'bs_sharing_tooltips' => true,
		'bs_sharing_facebook' => true,
		'bs_sharing_x_twitter' => true,
		'bs_sharing_flipboard' => false,
		'bs_sharing_pinterest' => false,
		'bs_sharing_whatsapp' => false,
		'bs_sharing_linkedin' => false,
		'bs_sharing_tumblr' => false,
		'bs_sharing_reddit' => false,
		'bs_sharing_vk' => false,
		'bs_sharing_telegram' => false,
		'bs_sharing_email' => false,
		'bs_sharing_copy' => true,
		'bs_sharing_print' => true,
		'bs_sharing_text_color' => [
			'normal' => '',
			'hover' => '',
		],
		'bs_sharing_bg_color' => [
			'normal' => '',
			'hover' => '',
		],
		'bs_toc_enable' => true,
		'bs_toc_heading_text' => 'Table of Contents',
		'bs_toc_supported_tags' => ['2', '3'],
		'bs_toc_layout' => '1',
		'bs_toc_bg_color' => '',
		'bs_toc_box_shadow' => true,
		'bs_toc_show_dividers' => true,
		'bs_nav_enable' => true,
		'bs_nav_style' => 's0-nr',
		'bs_nav_arrow' => 'chevron',
		'bs_nav_dividers' => true,
		'bs_nav_prev_text' => 'Previous Article',
		'bs_nav_next_text' => 'Next Article',
		'bs_nav_padding' =>	[
			'desktop' => [
				'top'      => '40',
				'right'    => '',
				'bottom'   => '50',
				'left'     => '',
				'isLinked' => false,
			],
			'tablet'  => [
				'top'      => '',
				'right'    => '',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => false,
			],
			'mobile'  => [
				'top'      => '',
				'right'    => '',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => false,
			],
		],
		'bs_nav_margin' =>	[
			'desktop' => [
				'top'      => '50',
				'right'    => '',
				'bottom'   => '50',
				'left'     => '',
				'isLinked' => false,
			],
			'tablet'  => [
				'top'      => '',
				'right'    => '',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => false,
			],
			'mobile'  => [
				'top'      => '',
				'right'    => '',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => false,
			],
		],
		'bs_author_enable' => true,
		'bs_author_style' => 's4',
		'bs_author_avatar_size' => 100,
		'bs_author_avatar_radius' => true,
		'bs_author_section_divider' => true,
		'bs_author_padding' =>	[
			'desktop' => [
				'top'      => '25',
				'right'    => '',
				'bottom'   => '50',
				'left'     => '',
				'isLinked' => false,
			],
			'tablet'  => [
				'top'      => '',
				'right'    => '',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => false,
			],
			'mobile'  => [
				'top'      => '',
				'right'    => '',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => false,
			],
		],
		'bs_author_margin' =>	[
			'desktop' => [
				'top'      => '',
				'right'    => '',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => false,
			],
			'tablet'  => [
				'top'      => '',
				'right'    => '',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => false,
			],
			'mobile'  => [
				'top'      => '',
				'right'    => '',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => false,
			],
		],

		'bs_related_enable' => true,
		'bs_related_query' => 'related',
		'bs_related_title' => 'Related Posts',
		'bs_related_ppp' => '3',
		'bs_related_section_divider' => true,
		'bs_related_padding' =>	[
			'desktop' => [
				'top'      => '25',
				'right'    => '',
				'bottom'   => '45',
				'left'     => '',
				'isLinked' => false,
			],
			'tablet'  => [
				'top'      => '',
				'right'    => '',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => false,
			],
			'mobile'  => [
				'top'      => '',
				'right'    => '',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => false,
			],
		],
		'bs_related_margin' =>	[
			'desktop' => [
				'top'      => '',
				'right'    => '',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => true,
			],
			'tablet'  => [
				'top'      => '',
				'right'    => '',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => true,
			],
			'mobile'  => [
				'top'      => '',
				'right'    => '',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => true,
			],
		],

		'bs_newsletter_enable' => true,
		'bs_newsletter_title' => 'Sign Up For Daily Newsletter',
		'bs_newsletter_description' => 'Stay updated with our weekly newsletter. Subscribe now to never miss an update!',
		'bs_newsletter_shortcode' => '[mc4wp_form]',
		'bs_newsletter_policy' => '',
		'bs_newsletter_section_divider' => true,
		'bs_newsletter_padding' =>	[
			'desktop' => [
				'top'      => '25',
				'right'    => '',
				'bottom'   => '50',
				'left'     => '',
				'isLinked' => false,
			],
			'tablet'  => [
				'top'      => '',
				'right'    => '',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => false,
			],
			'mobile'  => [
				'top'      => '',
				'right'    => '',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => false,
			],
		],
		'bs_newsletter_margin' =>	[
			'desktop' => [
				'top'      => '',
				'right'    => '',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => false,
			],
			'tablet'  => [
				'top'      => '',
				'right'    => '',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => false,
			],
			'mobile'  => [
				'top'      => '',
				'right'    => '',
				'bottom'   => '',
				'left'     => '',
				'isLinked' => false,
			],
		],
		// Blog Single: Advanced 
		'bs_advanced_rpbar_enable' => false,
		'bs_advanced_rpbar_color' => '#f84643',
		'bs_advanced_rpbar_height' => '4',
		'bs_advanced_load_posts_enable' => false,
		'bs_advanced_load_posts_cont_read_enable' => true,
		'bs_advanced_load_posts_same_cat' => false,

		// Preloader
		'preloader_enable' => false,
		'preloader_type' => 'logo',
		'preloader_bg_color' => '#ffffff',
		'preloader_anim_color' => '#000000',
		'preloader_logo_width' => '200',
	];

    return $theme_defaults;
}